<?php
$pageConfigs = ['navbarType' => 'hidden', 'contentLayout' => 'wide'];
$configData = Helper::appClasses();
$statusMap = [
  'pending' => ['Pendiente', 'warning'],
  'confirmed' => ['Confirmado', 'info'],
  'at_restaurant' => ['En restaurante', 'primary'],
  'en_route' => ['En camino', 'primary'],
  'delivered' => ['Entregado', 'success'],
  'cancelled' => ['Cancelado', 'danger'],
];
?>



<?php $__env->startSection('title', 'Pedidos'); ?>

<?php $__env->startSection('content'); ?>
<div class="courier-orders">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h4 class="mb-0">Pedidos activos</h4>
    <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('courier.dashboard')); ?>">Ver mapa</a>
  </div>

  <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
  <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
  <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
    <div class="alert alert-danger">
      <ul class="mb-0">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
      </ul>
    </div>
  <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

  <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(($activeDeliveries ?? collect())->count()): ?>
    <div class="card mb-3">
      <div class="card-header">
        <div class="d-flex align-items-center justify-content-between">
          <h6 class="mb-0">Pedidos en progreso</h6>
          <span class="badge bg-label-secondary"><?php echo e(($activeDeliveries ?? collect())->count()); ?></span>
        </div>
      </div>
      <div class="card-body">
        <div class="row g-3">
          <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $activeDeliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              [$label, $color] = $statusMap[$delivery->status] ?? ['Pendiente', 'warning'];
              $origin = $delivery->restaurant?->address ?? '';
              $destination = $delivery->delivery_address ?? '';
              $navApp = auth()->user()->nav_app ?? 'maps';
              $navUrl = $navApp === 'waze'
                ? 'https://waze.com/ul?q=' . urlencode($destination) . '&navigate=yes'
                : 'https://www.google.com/maps/dir/?api=1&origin=' . urlencode($origin) . '&destination=' . urlencode($destination);
              $needsDetails = $delivery->is_urgent && (
                empty($delivery->customer_name)
                || $delivery->customer_name === 'Por definir'
                || empty($delivery->delivery_address)
                || $delivery->delivery_address === 'Por definir'
                || empty($delivery->customer_phone)
              );
            ?>
            <div class="col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <div class="d-flex justify-content-between align-items-center">
                    <span class="badge bg-<?php echo e($color); ?>-subtle text-<?php echo e($color); ?>"><?php echo e($label); ?></span>
                    <small class="text-muted">#<?php echo e($delivery->id); ?></small>
                  </div>
                  <div class="mt-2">
                    <div class="fw-semibold"><?php echo e($delivery->customer_name); ?></div>
                    <small class="text-muted"><?php echo e($delivery->delivery_address); ?></small>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($delivery->is_urgent): ?>
                      <span class="badge bg-label-danger ms-1">Urgente</span>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                  </div>
                  <div class="mt-2">
                    <div class="detail-row">
                      <span class="text-muted">Recogida</span>
                      <span><?php echo e($delivery->restaurant?->address ?? 'Restaurante'); ?></span>
                    </div>
                    <div class="detail-row">
                      <span class="text-muted">Entrega</span>
                      <span><?php echo e($delivery->delivery_address); ?></span>
                    </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($delivery->delivery_address_extra): ?>
                      <div class="detail-row">
                        <span class="text-muted">Extra</span>
                        <span><?php echo e($delivery->delivery_address_extra); ?></span>
                      </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                  </div>
                  <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($delivery->is_urgent): ?>
                    <div class="mt-3">
                      <div class="d-flex align-items-center justify-content-between mb-2">
                        <div class="text-muted small">Datos del cliente</div>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$needsDetails): ?>
                          <button class="btn btn-xs btn-outline-secondary" type="button" data-toggle-edit>
                            <i class="icon-base ti tabler-edit"></i>
                          </button>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                      </div>
                      <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($needsDetails): ?>
                        <form method="POST" action="<?php echo e(route('courier.deliveries.details', $delivery)); ?>">
                          <?php echo csrf_field(); ?>
                          <input class="form-control form-control-sm mb-2" name="customer_name" placeholder="Nombre del cliente" value="<?php echo e($delivery->customer_name !== 'Por definir' ? $delivery->customer_name : ''); ?>" required>
                          <input class="form-control form-control-sm mb-2" name="customer_phone" placeholder="Teléfono" value="<?php echo e($delivery->customer_phone ?? ''); ?>">
                          <input class="form-control form-control-sm mb-2 courier-address-input"
                            name="delivery_address"
                            placeholder="Dirección de entrega"
                            value="<?php echo e($delivery->delivery_address !== 'Por definir' ? $delivery->delivery_address : ''); ?>"
                            data-zone-lat="<?php echo e($courier?->zone?->center_lat); ?>"
                            data-zone-lng="<?php echo e($courier?->zone?->center_lng); ?>"
                            data-zone-radius="<?php echo e($courier?->zone?->radius_km); ?>" required>
                          <input class="form-control form-control-sm mb-2" name="delivery_address_extra" placeholder="Dirección adicional" value="<?php echo e($delivery->delivery_address_extra ?? ''); ?>">
                          <button class="btn btn-outline-primary btn-sm w-100" type="submit">Guardar datos</button>
                        </form>
                        <small class="text-danger d-block mt-2">Completa los datos para poder finalizar la entrega.</small>
                      <?php else: ?>
                        <div class="urgent-summary" data-editable-block>
                          <div class="detail-row">
                            <span class="text-muted">Cliente</span>
                            <span><?php echo e($delivery->customer_name); ?></span>
                          </div>
                          <div class="detail-row">
                            <span class="text-muted">Teléfono</span>
                            <span><?php echo e($delivery->customer_phone ?? '-'); ?></span>
                          </div>
                          <div class="detail-row">
                            <span class="text-muted">Dirección</span>
                            <span><?php echo e($delivery->delivery_address); ?></span>
                          </div>
                          <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($delivery->delivery_address_extra): ?>
                            <div class="detail-row">
                              <span class="text-muted">Extra</span>
                              <span><?php echo e($delivery->delivery_address_extra); ?></span>
                            </div>
                          <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <form class="d-none" method="POST" action="<?php echo e(route('courier.deliveries.details', $delivery)); ?>" data-edit-form>
                          <?php echo csrf_field(); ?>
                          <input class="form-control form-control-sm mb-2" name="customer_name" placeholder="Nombre del cliente" value="<?php echo e($delivery->customer_name !== 'Por definir' ? $delivery->customer_name : ''); ?>" required>
                          <input class="form-control form-control-sm mb-2" name="customer_phone" placeholder="Teléfono" value="<?php echo e($delivery->customer_phone ?? ''); ?>">
                          <input class="form-control form-control-sm mb-2 courier-address-input"
                            name="delivery_address"
                            placeholder="Dirección de entrega"
                            value="<?php echo e($delivery->delivery_address !== 'Por definir' ? $delivery->delivery_address : ''); ?>"
                            data-zone-lat="<?php echo e($courier?->zone?->center_lat); ?>"
                            data-zone-lng="<?php echo e($courier?->zone?->center_lng); ?>"
                            data-zone-radius="<?php echo e($courier?->zone?->radius_km); ?>" required>
                          <input class="form-control form-control-sm mb-2" name="delivery_address_extra" placeholder="Dirección adicional" value="<?php echo e($delivery->delivery_address_extra ?? ''); ?>">
                          <button class="btn btn-outline-primary btn-sm w-100" type="submit">Guardar cambios</button>
                        </form>
                      <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                  <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                  <div class="d-flex flex-wrap gap-2 mt-3">
                    <a class="btn btn-outline-primary btn-sm" href="<?php echo e($navUrl); ?>" target="_blank" rel="noopener">Abrir navegación</a>
                    <?php
                      $nextAction = match ($delivery->status) {
                        'pending' => ['confirmed', 'Confirmar pedido', 'btn-primary'],
                        'confirmed' => ['at_restaurant', 'He llegado al restaurante', 'btn-info'],
                        'at_restaurant' => ['en_route', 'Salir al cliente', 'btn-warning'],
                        'en_route' => ['delivered', 'Entregado', 'btn-success'],
                        default => null,
                      };
                    ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($nextAction): ?>
                      <form method="POST" action="<?php echo e(route('courier.deliveries.status', $delivery)); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="status" value="<?php echo e($nextAction[0]); ?>" />
                        <button class="btn <?php echo e($nextAction[2]); ?> btn-sm" type="submit" <?php if($nextAction[0] === 'delivered' && $needsDetails): ?> disabled <?php endif; ?>>
                          <?php echo e($nextAction[1]); ?>

                        </button>
                      </form>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
      </div>
    </div>
  <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

  <nav class="courier-bottom-nav">
    <a href="<?php echo e(route('courier.dashboard')); ?>">
      <i class="icon-base ti tabler-map"></i>
    </a>
    <a class="active" href="<?php echo e(route('courier.orders.index')); ?>">
      <i class="icon-base ti tabler-clipboard-text"></i>
    </a>
    <a href="<?php echo e(route('courier.records.index')); ?>">
      <i class="icon-base ti tabler-history"></i>
    </a>
    <a href="<?php echo e(route('courier.profile.edit')); ?>">
      <i class="icon-base ti tabler-user"></i>
    </a>
  </nav>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
  <style>
    .courier-orders {
      min-height: 100vh;
    }
    .courier-address-input {
      border: 1px solid #e0e2ee;
    }
    .detail-row {
      display: flex;
      justify-content: space-between;
      gap: 8px;
      font-size: 0.85rem;
    }
    .day-list {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
    }
    .day-pill {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      padding: 8px 12px;
      border-radius: 999px;
      border: 1px solid rgba(15, 20, 34, 0.12);
      text-decoration: none;
      color: #4b465c;
      background: #fff;
      font-weight: 600;
    }
    .day-pill.active {
      border-color: rgba(235, 61, 99, 0.4);
      background: rgba(235, 61, 99, 0.08);
      color: #eb3d63;
    }
    .mobile-only {
      display: none;
    }
    .courier-bottom-nav {
      position: fixed;
      left: 0;
      right: 0;
      bottom: 0;
      background: #fff;
      border-top: 1px solid rgba(15, 20, 34, 0.08);
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      padding: 8px 14px 12px;
      z-index: 20;
    }
    .courier-bottom-nav a {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 2px;
      color: #6f6b7d;
      font-size: 12px;
      text-decoration: none;
    }
    .courier-bottom-nav a i {
      font-size: 20px;
    }
    .courier-bottom-nav a.active {
      color: #28c76f;
      font-weight: 600;
    }
    @media (max-width: 991px) {
      .desktop-only {
        display: none;
      }
      .mobile-only {
        display: block;
      }
      body {
        padding-bottom: 70px;
      }
      #layout-menu,
      .layout-navbar,
      .layout-menu-toggle,
      .content-footer {
        display: none !important;
      }
      .container-xxl,
      .container-xl,
      .container-lg,
      .container-md,
      .container-sm,
      .container {
        --bs-gutter-x: 0.75rem !important;
      }
    }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <script>
    window.initCourierOrderAutocomplete = function initCourierOrderAutocomplete() {
      const inputs = document.querySelectorAll('.courier-address-input');
      if (!inputs.length || !window.google || !google.maps || !google.maps.places) return;

      inputs.forEach((input) => {
        if (input.dataset.bound === 'true') return;
        input.dataset.bound = 'true';

        const zoneLat = parseFloat(input.dataset.zoneLat);
        const zoneLng = parseFloat(input.dataset.zoneLng);
        const zoneRadiusKm = parseFloat(input.dataset.zoneRadius) || 8;
        let bounds = null;

        if (!Number.isNaN(zoneLat) && !Number.isNaN(zoneLng)) {
          const zoneCircle = new google.maps.Circle({
            center: { lat: zoneLat, lng: zoneLng },
            radius: zoneRadiusKm * 1000,
          });
          bounds = zoneCircle.getBounds();
        }

        const autocomplete = new google.maps.places.Autocomplete(input, {
          componentRestrictions: { country: 'es' },
          fields: ['formatted_address'],
        });

        if (bounds) {
          autocomplete.setBounds(bounds);
          autocomplete.setOptions({ strictBounds: true });
        }
      });
    };

    (function loadCourierPlacesScript() {
      if (window.google && window.google.maps) {
        window.initCourierOrderAutocomplete();
        return;
      }
      const script = document.createElement('script');
      script.src = 'https://maps.googleapis.com/maps/api/js?key=<?php echo e(config('services.google.maps_key') ?: env('GOOGLE_MAPS_API_KEY')); ?>&libraries=places&loading=async&callback=initCourierOrderAutocomplete';
      script.async = true;
      script.defer = true;
      document.head.appendChild(script);
    })();

    document.addEventListener('click', (event) => {
      const toggle = event.target.closest('[data-toggle-edit]');
      if (!toggle) return;
      const card = toggle.closest('.card-body');
      if (!card) return;
      const summary = card.querySelector('[data-editable-block]');
      const form = card.querySelector('[data-edit-form]');
      if (!summary || !form) return;
      summary.classList.toggle('d-none');
      form.classList.toggle('d-none');
      if (!form.classList.contains('d-none')) {
        window.initCourierOrderAutocomplete();
      }
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/w/Documents/TAKS/resources/views/courier/orders/index.blade.php ENDPATH**/ ?>