<?php $__env->startSection('title', 'Panel de administración'); ?>

<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/apex-charts/apex-charts.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss'
]); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss'); ?>
<style>
  #admin-dashboard .taks-accent {
    color: #EB3D63;
  }

  #admin-dashboard .taks-pill {
    background: rgba(235, 61, 99, 0.12);
    color: #EB3D63;
    border: 1px solid rgba(235, 61, 99, 0.25);
  }

  #admin-dashboard .taks-card {
    border: 1px solid rgba(235, 61, 99, 0.12);
    box-shadow: 0 6px 18px rgba(47, 43, 61, 0.06);
  }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/apex-charts/apexcharts.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
]); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
  window.AdminDashboard = {
    ordersByDay: <?php echo json_encode($ordersByDay, 15, 512) ?>,
    statusCounts: <?php echo json_encode($statusCounts, 15, 512) ?>,
    paymentSplit: <?php echo json_encode($paymentSplit, 15, 512) ?>,
    brandColor: '#EB3D63'
  };
</script>
<?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/admin-dashboard.js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row g-6" id="admin-dashboard">
  <div class="col-12">
    <h4 class="mb-1">Panel de administración</h4>
    <p class="text-muted mb-3">Resumen general del sistema y actividad reciente.</p>
    <form class="row g-2 align-items-end" method="GET" action="<?php echo e(route('admin.dashboard')); ?>">
      <div class="col-12 col-md-3">
        <label class="form-label">Desde</label>
        <input class="form-control" type="date" name="from" value="<?php echo e($rangeStart->format('Y-m-d')); ?>">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Hasta</label>
        <input class="form-control" type="date" name="to" value="<?php echo e($rangeEnd->format('Y-m-d')); ?>">
      </div>
      <div class="col-12 col-md-6 d-flex gap-2">
        <button class="btn btn-primary mt-2" type="submit">
          <i class="icon-base ti tabler-filter me-1"></i> Filtrar
        </button>
        <a class="btn btn-label-secondary mt-2" href="<?php echo e(route('admin.dashboard')); ?>">Limpiar</a>
        <div class="ms-auto mt-2 taks-pill px-3 py-2 rounded d-inline-flex align-items-center">
          <i class="icon-base ti tabler-calendar-event me-2"></i>
          <span>
            Rango: <?php echo e($rangeStart->locale('es')->translatedFormat('d M Y')); ?>

            · <?php echo e($rangeEnd->locale('es')->translatedFormat('d M Y')); ?>

          </span>
        </div>
      </div>
    </form>
  </div>

  <!-- KPI cards -->
  <div class="col-lg-3 col-sm-6">
    <div class="card card-border-shadow-primary h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-package icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0"><?php echo e($orderTotals['total'] ?? 0); ?></h4>
        </div>
        <p class="mb-1">Pedidos en rango</p>
        <p class="mb-0">
          <span class="text-heading fw-medium me-2"><?php echo e($orderTotals['today'] ?? 0); ?></span>
          <small class="text-body-secondary">hoy</small>
        </p>
      </div>
    </div>
  </div>
  <div class="col-lg-3 col-sm-6">
    <div class="card card-border-shadow-warning h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-clock icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0"><?php echo e($orderTotals['pending'] ?? 0); ?></h4>
        </div>
        <p class="mb-1">Pendientes</p>
        <p class="mb-0">
          <span class="text-heading fw-medium me-2"><?php echo e($orderTotals['urgent'] ?? 0); ?></span>
          <small class="text-body-secondary">urgentes</small>
        </p>
      </div>
    </div>
  </div>
  <div class="col-lg-3 col-sm-6">
    <div class="card card-border-shadow-info h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-bike icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0"><?php echo e($orderTotals['confirmed'] ?? 0); ?></h4>
        </div>
        <p class="mb-1">Confirmadas</p>
        <p class="mb-0">
          <span class="text-heading fw-medium me-2"><?php echo e($courierOnlineCount ?? 0); ?></span>
          <small class="text-body-secondary">repartidores en línea</small>
        </p>
      </div>
    </div>
  </div>
  <div class="col-lg-3 col-sm-6">
    <div class="card card-border-shadow-success h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-success">
              <i class="icon-base ti tabler-circle-check icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0"><?php echo e($orderTotals['delivered'] ?? 0); ?></h4>
        </div>
        <p class="mb-1">Entregadas</p>
        <p class="mb-0">
          <span class="text-heading fw-medium me-2"><?php echo e($orderTotals['cancelled'] ?? 0); ?></span>
          <small class="text-body-secondary">canceladas</small>
        </p>
      </div>
    </div>
  </div>
  <!--/ KPI cards -->

  <div class="col-lg-4 col-sm-6">
    <div class="card card-border-shadow-primary h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-currency-euro icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0">€<?php echo e(number_format($incomeTotal ?? 0, 2)); ?></h4>
        </div>
        <p class="mb-1">Ingresos completados</p>
        <p class="mb-0 text-muted">En el rango seleccionado</p>
      </div>
    </div>
  </div>
  <div class="col-lg-4 col-sm-6">
    <div class="card card-border-shadow-info h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-cash icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0">€<?php echo e(number_format($incomeCash ?? 0, 2)); ?></h4>
        </div>
        <p class="mb-1">Pagos en efectivo</p>
        <p class="mb-0 text-muted">Pedidos completados</p>
      </div>
    </div>
  </div>
  <div class="col-lg-4 col-sm-6">
    <div class="card card-border-shadow-warning h-100 taks-card">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-4">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-wallet icon-28px"></i>
            </span>
          </div>
          <h4 class="mb-0">€<?php echo e(number_format($incomeWallet ?? 0, 2)); ?></h4>
        </div>
        <p class="mb-1">Pagos por wallet</p>
        <p class="mb-0 text-muted">Pedidos completados</p>
      </div>
    </div>
  </div>

  <!-- Charts -->
  <div class="col-xxl-6 col-lg-6">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <div class="card-title mb-0">
          <h5 class="mb-1">Pedidos por día</h5>
          <p class="card-subtitle">
            <?php echo e($rangeStart->locale('es')->translatedFormat('d M')); ?>

            -
            <?php echo e($rangeEnd->locale('es')->translatedFormat('d M')); ?>

          </p>
        </div>
      </div>
      <div class="card-body">
        <div id="ordersByDayChart"></div>
      </div>
    </div>
  </div>

  <div class="col-xxl-6 col-lg-6">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <div class="card-title mb-0">
          <h5 class="mb-1">Estados de pedidos</h5>
          <p class="card-subtitle">Distribución general</p>
        </div>
      </div>
      <div class="card-body">
        <div id="ordersStatusChart"></div>
      </div>
    </div>
  </div>
  <div class="col-xxl-6 col-lg-6">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <div class="card-title mb-0">
          <h5 class="mb-1">Pagos por método</h5>
          <p class="card-subtitle">Efectivo vs Wallet</p>
        </div>
      </div>
      <div class="card-body">
        <div id="paymentSplitChart"></div>
      </div>
    </div>
  </div>
  <!--/ Charts -->

  <!-- Entities -->
  <div class="col-xxl-4 col-lg-6">
    <div class="card h-100">
      <div class="card-header">
        <h5 class="card-title m-0">Entidades</h5>
      </div>
      <div class="card-body">
        <ul class="p-0 m-0">
          <li class="d-flex mb-4 align-items-center">
            <div class="avatar flex-shrink-0 me-4">
              <span class="avatar-initial rounded bg-label-primary"><i class="icon-base ti tabler-building-store icon-24px"></i></span>
            </div>
            <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
              <div class="me-2">
                <h6 class="mb-1 fw-normal">Restaurantes</h6>
                <small class="text-muted">Total registrados</small>
              </div>
              <div class="user-progress">
                <h6 class="text-body mb-0"><?php echo e($restaurantCount); ?></h6>
              </div>
            </div>
          </li>
          <li class="d-flex mb-4 align-items-center">
            <div class="avatar flex-shrink-0 me-4">
              <span class="avatar-initial rounded bg-label-info"><i class="icon-base ti tabler-bike icon-24px"></i></span>
            </div>
            <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
              <div class="me-2">
                <h6 class="mb-1 fw-normal">Repartidores</h6>
                <small class="text-muted">Total registrados</small>
              </div>
              <div class="user-progress">
                <h6 class="text-body mb-0"><?php echo e($courierCount); ?></h6>
              </div>
            </div>
          </li>
          <li class="d-flex align-items-center">
            <div class="avatar flex-shrink-0 me-4">
              <span class="avatar-initial rounded bg-label-warning"><i class="icon-base ti tabler-map-pin icon-24px"></i></span>
            </div>
            <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
              <div class="me-2">
                <h6 class="mb-1 fw-normal">Zonas</h6>
                <small class="text-muted">Zonas activas</small>
              </div>
              <div class="user-progress">
                <h6 class="text-body mb-0"><?php echo e($zoneCount); ?></h6>
              </div>
            </div>
          </li>
        </ul>
      </div>
    </div>
  </div>

  <!-- Top restaurants -->
  <div class="col-xxl-8 col-lg-6">
    <div class="card h-100">
      <div class="card-header d-flex align-items-center justify-content-between">
        <h5 class="card-title m-0">Restaurantes con más pedidos</h5>
        <a class="btn btn-sm btn-outline-primary" href="<?php echo e(route('admin.restaurants.index')); ?>">Ver todos</a>
      </div>
      <div class="table-responsive">
        <table class="table table-borderless mb-0">
          <thead class="border-bottom">
            <tr>
              <th>Restaurante</th>
              <th>Zona</th>
              <th class="text-end">Pedidos</th>
            </tr>
          </thead>
          <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $topRestaurants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td><?php echo e($row->restaurant?->name ?? '—'); ?></td>
                <td class="text-muted"><?php echo e($row->restaurant?->zone?->name ?? '—'); ?></td>
                <td class="text-end fw-semibold"><?php echo e($row->total); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="3" class="text-center text-muted py-4">Sin datos todavía.</td>
              </tr>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/w/Documents/TAKS/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>