<?php
$configData = Helper::appClasses();
$stats = $stats ?? ['total' => 0, 'active' => 0, 'inactive' => 0, 'restaurants' => 0];
?>



<?php $__env->startSection('title', 'Zonas'); ?>

<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
]); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
]); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const table = document.querySelector('#zones-table');
    if (table && window.$ && $.fn.DataTable) {
      $('#zones-table').DataTable({
        order: [[1, 'asc']],
        pageLength: 10,
        language: {
          search: 'Buscar:',
          emptyTable: 'Sin zonas todavía.'
        }
      });
    }
  });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
  <span></span>
</div>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
  <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<div class="row g-4 mb-4">
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Total</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2"><?php echo e($stats['total']); ?></h4>
            </div>
            <small class="mb-0">Zonas registradas</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-map-pin icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Activas</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2"><?php echo e($stats['active']); ?></h4>
            </div>
            <small class="mb-0">En operación</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-success">
              <i class="icon-base ti tabler-circle-check icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Inactivas</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2"><?php echo e($stats['inactive']); ?></h4>
            </div>
            <small class="mb-0">Fuera de servicio</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-alert-triangle icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Restaurantes</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2"><?php echo e($stats['restaurants']); ?></h4>
            </div>
            <small class="mb-0">En todas las zonas</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-building-store icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header border-bottom d-flex align-items-center justify-content-between">
    <h5 class="card-title mb-0">Listado de zonas</h5>
    <a class="btn btn-primary btn-sm" href="<?php echo e(route('admin.zones.create')); ?>">
      <i class="icon-base ti tabler-plus me-1"></i> Nueva zona
    </a>
  </div>
  <div class="card-datatable table-responsive">
    <table class="table" id="zones-table">
      <thead class="border-top">
        <tr>
          <th>Zona</th>
          <th>Ciudad</th>
          <th>Restaurantes</th>
          <th>Radio (km)</th>
          <th>Estado</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td>
              <div class="d-flex align-items-center">
                <div class="avatar me-2">
                  <span class="avatar-initial rounded-circle bg-label-primary">
                    <?php echo e(strtoupper(substr($zone->name, 0, 2))); ?>

                  </span>
                </div>
                <div class="d-flex flex-column">
                  <span class="fw-medium"><?php echo e($zone->name); ?></span>
                  <small class="text-muted"><?php echo e($zone->city ?? '—'); ?></small>
                </div>
              </div>
            </td>
            <td><?php echo e($zone->city ?? '-'); ?></td>
            <td><?php echo e($zone->restaurants_count); ?></td>
            <td><?php echo e($zone->radius_km ?? '-'); ?></td>
            <td>
              <span class="badge bg-<?php echo e($zone->is_active ? 'success' : 'secondary'); ?>">
                <?php echo e($zone->is_active ? 'Activa' : 'Inactiva'); ?>

              </span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-icon btn-outline-primary" href="<?php echo e(route('admin.zones.edit', $zone)); ?>" title="Editar">
                <i class="icon-base ti tabler-edit"></i>
              </a>
              <form class="d-inline" method="POST" action="<?php echo e(route('admin.zones.destroy', $zone)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn btn-sm btn-icon btn-outline-danger" type="submit" onclick="return confirm('¿Eliminar zona?')" title="Eliminar">
                  <i class="icon-base ti tabler-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/w/Documents/TAKS/resources/views/admin/zones/index.blade.php ENDPATH**/ ?>