<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ZoneController;
use App\Http\Controllers\Admin\RestaurantController;
use App\Http\Controllers\Admin\CourierController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Telegram\WebhookController as TelegramWebhookController;
use App\Http\Controllers\Restaurant\DashboardController as RestaurantDashboardController;
use App\Http\Controllers\Restaurant\DeliveryController as RestaurantDeliveryController;
use App\Http\Controllers\Restaurant\OrdersController as RestaurantOrdersController;
use App\Http\Controllers\Courier\DashboardController as CourierDashboardController;
use App\Http\Controllers\Courier\DeliveryController as CourierDeliveryController;
use App\Http\Controllers\Courier\LocationController as CourierLocationController;
use App\Http\Controllers\Courier\OrdersController as CourierOrdersController;
use App\Http\Controllers\Courier\ProfileController as CourierProfileController;
use App\Http\Controllers\Courier\PushController as CourierPushController;
use App\Http\Controllers\Courier\RecordsController as CourierRecordsController;

Route::get('/', function () {
    $user = auth()->user();
    if (!$user) {
        return redirect()->route('login');
    }

    if ($user->role === 'restaurant') {
        return redirect()->route('restaurant.dashboard');
    }
    if ($user->role === 'courier') {
        return redirect()->route('courier.dashboard');
    }

    return redirect()->route('admin.dashboard');
});

Route::middleware(['auth', 'admin'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('orders', [OrderController::class, 'index'])->name('orders.index');
        Route::get('orders/poll', [OrderController::class, 'poll'])->name('orders.poll');
        Route::get('orders/{delivery}', [OrderController::class, 'show'])->name('orders.show');
        Route::post('orders/{delivery}/status', [OrderController::class, 'updateStatus'])->name('orders.status');
        Route::post('orders/{delivery}/assign', [OrderController::class, 'assignCourier'])->name('orders.assign');
        Route::resource('zones', ZoneController::class)->except(['show']);
        Route::resource('restaurants', RestaurantController::class)->except(['show']);
        Route::get('restaurants/{restaurant}', [RestaurantController::class, 'show'])->name('restaurants.show');
        Route::get('restaurants/{restaurant}/movements', [RestaurantController::class, 'movements'])->name('restaurants.movements');
        Route::get('restaurants/{restaurant}/wallet', [RestaurantController::class, 'wallet'])->name('restaurants.wallet');
        Route::post('restaurants/{restaurant}/wallet/topup', [RestaurantController::class, 'walletTopup'])->name('restaurants.wallet.topup');
        Route::post('restaurants/{restaurant}/wallet/charge', [RestaurantController::class, 'walletCharge'])->name('restaurants.wallet.charge');
        Route::resource('couriers', CourierController::class)->except(['show']);
        Route::get('couriers/{courier}', [CourierController::class, 'show'])->name('couriers.show');
        Route::post('couriers/{courier}/force-online', [CourierController::class, 'forceOnline'])->name('couriers.force-online');
        Route::get('couriers/{courier}/movements', [CourierController::class, 'movements'])->name('couriers.movements');
        Route::get('couriers/{courier}/wallet', [CourierController::class, 'wallet'])->name('couriers.wallet');
        Route::post('couriers/{courier}/wallet/topup', [CourierController::class, 'walletTopup'])->name('couriers.wallet.topup');
        Route::post('couriers/{courier}/wallet/payout', [CourierController::class, 'walletPayout'])->name('couriers.wallet.payout');
    });

Route::middleware(['auth', 'role:restaurant'])
    ->prefix('restaurant')
    ->name('restaurant.')
    ->group(function () {
        Route::get('/', [RestaurantDashboardController::class, 'index'])->name('dashboard');
        Route::get('/urgent-status', [RestaurantDashboardController::class, 'urgentStatus'])->name('urgent.status');
        Route::get('/last-order-status', [RestaurantDashboardController::class, 'lastOrderStatus'])->name('last-order.status');
        Route::get('/orders', [RestaurantOrdersController::class, 'index'])->name('orders.index');
        Route::get('/wallet', [\App\Http\Controllers\Restaurant\WalletController::class, 'index'])->name('wallet');
        Route::post('/deliveries', [RestaurantDeliveryController::class, 'store'])->name('deliveries.store');
        Route::post('/deliveries/urgent', [RestaurantDeliveryController::class, 'urgent'])->name('deliveries.urgent');
        Route::post('/deliveries/{delivery}/reassign', [RestaurantDeliveryController::class, 'reassign'])->name('deliveries.reassign');
    });

Route::middleware(['auth', 'role:courier'])
    ->prefix('courier')
    ->name('courier.')
    ->group(function () {
        Route::get('/', [CourierDashboardController::class, 'index'])->name('dashboard');
        Route::get('/orders', [CourierOrdersController::class, 'index'])->name('orders.index');
        Route::get('/orders/{delivery}', [CourierOrdersController::class, 'show'])->name('orders.show');
        Route::get('/records', [CourierRecordsController::class, 'index'])->name('records.index');
        Route::get('/profile', [CourierProfileController::class, 'edit'])->name('profile.edit');
        Route::post('/profile', [CourierProfileController::class, 'update'])->name('profile.update');
        Route::post('/telegram/disconnect', [CourierProfileController::class, 'disconnectTelegram'])->name('telegram.disconnect');
        Route::post('/status', [CourierProfileController::class, 'updateStatus'])->name('status.update');
        Route::post('/deliveries/{delivery}/status', [CourierDeliveryController::class, 'updateStatus'])->name('deliveries.status');
        Route::post('/deliveries/{delivery}/reject', [CourierDeliveryController::class, 'reject'])->name('deliveries.reject');
        Route::post('/deliveries/{delivery}/details', [CourierDeliveryController::class, 'updateDetails'])->name('deliveries.details');
        Route::post('/location', [CourierLocationController::class, 'store'])->name('location.store');
        Route::post('/push/subscribe', [CourierPushController::class, 'subscribe'])->name('push.subscribe');
        Route::post('/push/unsubscribe', [CourierPushController::class, 'unsubscribe'])->name('push.unsubscribe');
    });

// Telegram Bot webhook (no auth). Protect with TELEGRAM_WEBHOOK_SECRET header.
Route::post('/telegram/webhook', TelegramWebhookController::class)->name('telegram.webhook');

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        $user = auth()->user();

        if ($user?->role === 'restaurant') {
            return redirect()->route('restaurant.dashboard');
        }
        if ($user?->role === 'courier') {
            return redirect()->route('courier.dashboard');
        }

        return redirect()->route('admin.dashboard');
    })->name('dashboard');
});
