<!-- BEGIN: Vendor JS-->

@vite(['resources/assets/vendor/libs/jquery/jquery.js', 'resources/assets/vendor/libs/popper/popper.js', 'resources/assets/vendor/js/bootstrap.js', 'resources/assets/vendor/libs/node-waves/node-waves.js'])

@if ($configData['hasCustomizer'])
  @vite('resources/assets/vendor/libs/pickr/pickr.js')
@endif

@vite(['resources/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js', 'resources/assets/vendor/libs/hammer/hammer.js', 'resources/assets/vendor/js/menu.js'])

@yield('vendor-script')
<!-- END: Page Vendor JS-->

<!-- BEGIN: Theme JS-->
@vite(['resources/assets/js/main.js'])
<!-- END: Theme JS-->

<!-- Pricing Modal JS-->
@stack('pricing-script')
<!-- END: Pricing Modal JS-->

<!-- BEGIN: Page JS-->
@yield('page-script')
<!-- END: Page JS-->

<!-- app JS -->
@vite(['resources/js/app.js'])
<!-- END: app JS-->

<script>
  // Keep UI preferences per-session (device/browser session). When user logs out,
  // remove per-role localStorage keys so next login starts clean.
  document.addEventListener('submit', (event) => {
    const form = event.target;
    if (!form || form.tagName !== 'FORM') return;

    const action = (form.getAttribute('action') || '').trim();
    if (!action) return;

    // Match "/logout" and ".../logout" (absolute URLs included).
    if (!/\/logout\/?$/.test(action)) return;

    try {
      [
        // Restaurant (view mode + tabs + urgent cooldown)
        'restaurant_view_mode',
        'restaurant_mobile_tab',
        'restaurant_urgent_until',
        'restaurant_urgent_clicked',
        // Courier (alerts + last delivery)
        'courier_alerts_enabled',
        'courier_audio_unlocked',
        'courier_last_delivery_id',
        // Admin (orders alerts)
        'admin_orders_alerts_enabled',
        'admin_orders_audio_unlocked',
        'admin_orders_last_delivery_id'
      ].forEach((k) => localStorage.removeItem(k));
    } catch (e) {
      // ignore
    }
  });
</script>
