@php
$pageConfigs = ['navbarType' => 'hidden', 'contentLayout' => 'wide'];
$configData = Helper::appClasses();
$statusMap = [
  'pending' => ['Pendiente', 'warning'],
  'confirmed' => ['Confirmado', 'info'],
  'at_restaurant' => ['En restaurante', 'primary'],
  'en_route' => ['En camino', 'primary'],
  'delivered' => ['Entregado', 'success'],
  'cancelled' => ['Cancelado', 'danger'],
];
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Pedidos')

@section('content')
<div class="courier-orders">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h4 class="mb-0">Pedidos activos</h4>
    <a class="btn btn-outline-secondary btn-sm" href="{{ route('courier.dashboard') }}">Ver mapa</a>
  </div>

  @if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  @if ($errors->any())
    <div class="alert alert-danger">
      <ul class="mb-0">
        @foreach ($errors->all() as $error)
          <li>{{ $error }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  @if (($activeDeliveries ?? collect())->count())
    <div class="card mb-3">
      <div class="card-header">
        <div class="d-flex align-items-center justify-content-between">
          <h6 class="mb-0">Pedidos en progreso</h6>
          <span class="badge bg-label-secondary">{{ ($activeDeliveries ?? collect())->count() }}</span>
        </div>
      </div>
      <div class="card-body">
        <div class="row g-3">
          @foreach ($activeDeliveries as $delivery)
            @php
              [$label, $color] = $statusMap[$delivery->status] ?? ['Pendiente', 'warning'];
              $origin = $delivery->restaurant?->address ?? '';
              $destination = $delivery->delivery_address ?? '';
              $navApp = auth()->user()->nav_app ?? 'maps';
              $navUrl = $navApp === 'waze'
                ? 'https://waze.com/ul?q=' . urlencode($destination) . '&navigate=yes'
                : 'https://www.google.com/maps/dir/?api=1&origin=' . urlencode($origin) . '&destination=' . urlencode($destination);
              $needsDetails = $delivery->is_urgent && (
                empty($delivery->customer_name)
                || $delivery->customer_name === 'Por definir'
                || empty($delivery->delivery_address)
                || $delivery->delivery_address === 'Por definir'
                || empty($delivery->customer_phone)
              );
            @endphp
            <div class="col-lg-6">
              <div class="card h-100">
                <div class="card-body">
                  <div class="d-flex justify-content-between align-items-center">
                    <span class="badge bg-{{ $color }}-subtle text-{{ $color }}">{{ $label }}</span>
                    <small class="text-muted">#{{ $delivery->id }}</small>
                  </div>
                  <div class="mt-2">
                    <div class="fw-semibold">{{ $delivery->customer_name }}</div>
                    <small class="text-muted">{{ $delivery->delivery_address }}</small>
                    @if ($delivery->is_urgent)
                      <span class="badge bg-label-danger ms-1">Urgente</span>
                    @endif
                  </div>
                  <div class="mt-2">
                    <div class="detail-row">
                      <span class="text-muted">Recogida</span>
                      <span>{{ $delivery->restaurant?->address ?? 'Restaurante' }}</span>
                    </div>
                    <div class="detail-row">
                      <span class="text-muted">Entrega</span>
                      <span>{{ $delivery->delivery_address }}</span>
                    </div>
                    @if ($delivery->delivery_address_extra)
                      <div class="detail-row">
                        <span class="text-muted">Extra</span>
                        <span>{{ $delivery->delivery_address_extra }}</span>
                      </div>
                    @endif
                  </div>
                  @if ($delivery->is_urgent)
                    <div class="mt-3">
                      <div class="d-flex align-items-center justify-content-between mb-2">
                        <div class="text-muted small">Datos del cliente</div>
                        @if (!$needsDetails)
                          <button class="btn btn-xs btn-outline-secondary" type="button" data-toggle-edit>
                            <i class="icon-base ti tabler-edit"></i>
                          </button>
                        @endif
                      </div>
                      @if ($needsDetails)
                        <form method="POST" action="{{ route('courier.deliveries.details', $delivery) }}">
                          @csrf
                          <input class="form-control form-control-sm mb-2" name="customer_name" placeholder="Nombre del cliente" value="{{ $delivery->customer_name !== 'Por definir' ? $delivery->customer_name : '' }}" required>
                          <input class="form-control form-control-sm mb-2" name="customer_phone" placeholder="Teléfono" value="{{ $delivery->customer_phone ?? '' }}">
                          <input class="form-control form-control-sm mb-2 courier-address-input"
                            name="delivery_address"
                            placeholder="Dirección de entrega"
                            value="{{ $delivery->delivery_address !== 'Por definir' ? $delivery->delivery_address : '' }}"
                            data-zone-lat="{{ $courier?->zone?->center_lat }}"
                            data-zone-lng="{{ $courier?->zone?->center_lng }}"
                            data-zone-radius="{{ $courier?->zone?->radius_km }}" required>
                          <input class="form-control form-control-sm mb-2" name="delivery_address_extra" placeholder="Dirección adicional" value="{{ $delivery->delivery_address_extra ?? '' }}">
                          <button class="btn btn-outline-primary btn-sm w-100" type="submit">Guardar datos</button>
                        </form>
                        <small class="text-danger d-block mt-2">Completa los datos para poder finalizar la entrega.</small>
                      @else
                        <div class="urgent-summary" data-editable-block>
                          <div class="detail-row">
                            <span class="text-muted">Cliente</span>
                            <span>{{ $delivery->customer_name }}</span>
                          </div>
                          <div class="detail-row">
                            <span class="text-muted">Teléfono</span>
                            <span>{{ $delivery->customer_phone ?? '-' }}</span>
                          </div>
                          <div class="detail-row">
                            <span class="text-muted">Dirección</span>
                            <span>{{ $delivery->delivery_address }}</span>
                          </div>
                          @if ($delivery->delivery_address_extra)
                            <div class="detail-row">
                              <span class="text-muted">Extra</span>
                              <span>{{ $delivery->delivery_address_extra }}</span>
                            </div>
                          @endif
                        </div>
                        <form class="d-none" method="POST" action="{{ route('courier.deliveries.details', $delivery) }}" data-edit-form>
                          @csrf
                          <input class="form-control form-control-sm mb-2" name="customer_name" placeholder="Nombre del cliente" value="{{ $delivery->customer_name !== 'Por definir' ? $delivery->customer_name : '' }}" required>
                          <input class="form-control form-control-sm mb-2" name="customer_phone" placeholder="Teléfono" value="{{ $delivery->customer_phone ?? '' }}">
                          <input class="form-control form-control-sm mb-2 courier-address-input"
                            name="delivery_address"
                            placeholder="Dirección de entrega"
                            value="{{ $delivery->delivery_address !== 'Por definir' ? $delivery->delivery_address : '' }}"
                            data-zone-lat="{{ $courier?->zone?->center_lat }}"
                            data-zone-lng="{{ $courier?->zone?->center_lng }}"
                            data-zone-radius="{{ $courier?->zone?->radius_km }}" required>
                          <input class="form-control form-control-sm mb-2" name="delivery_address_extra" placeholder="Dirección adicional" value="{{ $delivery->delivery_address_extra ?? '' }}">
                          <button class="btn btn-outline-primary btn-sm w-100" type="submit">Guardar cambios</button>
                        </form>
                      @endif
                    </div>
                  @endif
                  <div class="d-flex flex-wrap gap-2 mt-3">
                    <a class="btn btn-outline-primary btn-sm" href="{{ $navUrl }}" target="_blank" rel="noopener">Abrir navegación</a>
                    @php
                      $nextAction = match ($delivery->status) {
                        'pending' => ['confirmed', 'Confirmar pedido', 'btn-primary'],
                        'confirmed' => ['at_restaurant', 'He llegado al restaurante', 'btn-info'],
                        'at_restaurant' => ['en_route', 'Salir al cliente', 'btn-warning'],
                        'en_route' => ['delivered', 'Entregado', 'btn-success'],
                        default => null,
                      };
                    @endphp
                    @if ($nextAction)
                      <form method="POST" action="{{ route('courier.deliveries.status', $delivery) }}">
                        @csrf
                        <input type="hidden" name="status" value="{{ $nextAction[0] }}" />
                        <button class="btn {{ $nextAction[2] }} btn-sm" type="submit" @if ($nextAction[0] === 'delivered' && $needsDetails) disabled @endif>
                          {{ $nextAction[1] }}
                        </button>
                      </form>
                    @endif
                  </div>
                </div>
              </div>
            </div>
          @endforeach
        </div>
      </div>
    </div>
  @endif

  <nav class="courier-bottom-nav">
    <a href="{{ route('courier.dashboard') }}">
      <i class="icon-base ti tabler-map"></i>
    </a>
    <a class="active" href="{{ route('courier.orders.index') }}">
      <i class="icon-base ti tabler-clipboard-text"></i>
    </a>
    <a href="{{ route('courier.records.index') }}">
      <i class="icon-base ti tabler-history"></i>
    </a>
    <a href="{{ route('courier.profile.edit') }}">
      <i class="icon-base ti tabler-user"></i>
    </a>
  </nav>
</div>
@endsection

@section('page-style')
  <style>
    .courier-orders {
      min-height: 100vh;
    }
    .courier-address-input {
      border: 1px solid #e0e2ee;
    }
    .detail-row {
      display: flex;
      justify-content: space-between;
      gap: 8px;
      font-size: 0.85rem;
    }
    .day-list {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
    }
    .day-pill {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      padding: 8px 12px;
      border-radius: 999px;
      border: 1px solid rgba(15, 20, 34, 0.12);
      text-decoration: none;
      color: #4b465c;
      background: #fff;
      font-weight: 600;
    }
    .day-pill.active {
      border-color: rgba(235, 61, 99, 0.4);
      background: rgba(235, 61, 99, 0.08);
      color: #eb3d63;
    }
    .mobile-only {
      display: none;
    }
    .courier-bottom-nav {
      position: fixed;
      left: 0;
      right: 0;
      bottom: 0;
      background: #fff;
      border-top: 1px solid rgba(15, 20, 34, 0.08);
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      padding: 8px 14px 12px;
      z-index: 20;
    }
    .courier-bottom-nav a {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 2px;
      color: #6f6b7d;
      font-size: 12px;
      text-decoration: none;
    }
    .courier-bottom-nav a i {
      font-size: 20px;
    }
    .courier-bottom-nav a.active {
      color: #28c76f;
      font-weight: 600;
    }
    @media (max-width: 991px) {
      .desktop-only {
        display: none;
      }
      .mobile-only {
        display: block;
      }
      body {
        padding-bottom: 70px;
      }
      #layout-menu,
      .layout-navbar,
      .layout-menu-toggle,
      .content-footer {
        display: none !important;
      }
      .container-xxl,
      .container-xl,
      .container-lg,
      .container-md,
      .container-sm,
      .container {
        --bs-gutter-x: 0.75rem !important;
      }
    }
  </style>
@endsection

@section('page-script')
  <script>
    window.initCourierOrderAutocomplete = function initCourierOrderAutocomplete() {
      const inputs = document.querySelectorAll('.courier-address-input');
      if (!inputs.length || !window.google || !google.maps || !google.maps.places) return;

      inputs.forEach((input) => {
        if (input.dataset.bound === 'true') return;
        input.dataset.bound = 'true';

        const zoneLat = parseFloat(input.dataset.zoneLat);
        const zoneLng = parseFloat(input.dataset.zoneLng);
        const zoneRadiusKm = parseFloat(input.dataset.zoneRadius) || 8;
        let bounds = null;

        if (!Number.isNaN(zoneLat) && !Number.isNaN(zoneLng)) {
          const zoneCircle = new google.maps.Circle({
            center: { lat: zoneLat, lng: zoneLng },
            radius: zoneRadiusKm * 1000,
          });
          bounds = zoneCircle.getBounds();
        }

        const autocomplete = new google.maps.places.Autocomplete(input, {
          componentRestrictions: { country: 'es' },
          fields: ['formatted_address'],
        });

        if (bounds) {
          autocomplete.setBounds(bounds);
          autocomplete.setOptions({ strictBounds: true });
        }
      });
    };

    (function loadCourierPlacesScript() {
      if (window.google && window.google.maps) {
        window.initCourierOrderAutocomplete();
        return;
      }
      const script = document.createElement('script');
      script.src = 'https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_key') ?: env('GOOGLE_MAPS_API_KEY') }}&libraries=places&loading=async&callback=initCourierOrderAutocomplete';
      script.async = true;
      script.defer = true;
      document.head.appendChild(script);
    })();

    document.addEventListener('click', (event) => {
      const toggle = event.target.closest('[data-toggle-edit]');
      if (!toggle) return;
      const card = toggle.closest('.card-body');
      if (!card) return;
      const summary = card.querySelector('[data-editable-block]');
      const form = card.querySelector('[data-edit-form]');
      if (!summary || !form) return;
      summary.classList.toggle('d-none');
      form.classList.toggle('d-none');
      if (!form.classList.contains('d-none')) {
        window.initCourierOrderAutocomplete();
      }
    });
  </script>
@endsection
