@php
$configData = Helper::appClasses();
$stats = $stats ?? ['total' => 0, 'active' => 0, 'inactive' => 0, 'restaurants' => 0];
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Zonas')

@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
])
@endsection

@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
])
@endsection

@section('page-script')
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const table = document.querySelector('#zones-table');
    if (table && window.$ && $.fn.DataTable) {
      $('#zones-table').DataTable({
        order: [[1, 'asc']],
        pageLength: 10,
        language: {
          search: 'Buscar:',
          emptyTable: 'Sin zonas todavía.'
        }
      });
    }
  });
</script>
@endsection

@section('content')
<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
  <span></span>
</div>

@if (session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="row g-4 mb-4">
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Total</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['total'] }}</h4>
            </div>
            <small class="mb-0">Zonas registradas</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-map-pin icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Activas</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['active'] }}</h4>
            </div>
            <small class="mb-0">En operación</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-success">
              <i class="icon-base ti tabler-circle-check icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Inactivas</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['inactive'] }}</h4>
            </div>
            <small class="mb-0">Fuera de servicio</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-alert-triangle icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Restaurantes</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['restaurants'] }}</h4>
            </div>
            <small class="mb-0">En todas las zonas</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-building-store icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header border-bottom d-flex align-items-center justify-content-between">
    <h5 class="card-title mb-0">Listado de zonas</h5>
    <a class="btn btn-primary btn-sm" href="{{ route('admin.zones.create') }}">
      <i class="icon-base ti tabler-plus me-1"></i> Nueva zona
    </a>
  </div>
  <div class="card-datatable table-responsive">
    <table class="table" id="zones-table">
      <thead class="border-top">
        <tr>
          <th>Zona</th>
          <th>Ciudad</th>
          <th>Restaurantes</th>
          <th>Radio (km)</th>
          <th>Estado</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($zones as $zone)
          <tr>
            <td>
              <div class="d-flex align-items-center">
                <div class="avatar me-2">
                  <span class="avatar-initial rounded-circle bg-label-primary">
                    {{ strtoupper(substr($zone->name, 0, 2)) }}
                  </span>
                </div>
                <div class="d-flex flex-column">
                  <span class="fw-medium">{{ $zone->name }}</span>
                  <small class="text-muted">{{ $zone->city ?? '—' }}</small>
                </div>
              </div>
            </td>
            <td>{{ $zone->city ?? '-' }}</td>
            <td>{{ $zone->restaurants_count }}</td>
            <td>{{ $zone->radius_km ?? '-' }}</td>
            <td>
              <span class="badge bg-{{ $zone->is_active ? 'success' : 'secondary' }}">
                {{ $zone->is_active ? 'Activa' : 'Inactiva' }}
              </span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-icon btn-outline-primary" href="{{ route('admin.zones.edit', $zone) }}" title="Editar">
                <i class="icon-base ti tabler-edit"></i>
              </a>
              <form class="d-inline" method="POST" action="{{ route('admin.zones.destroy', $zone) }}">
                @csrf
                @method('DELETE')
                <button class="btn btn-sm btn-icon btn-outline-danger" type="submit" onclick="return confirm('¿Eliminar zona?')" title="Eliminar">
                  <i class="icon-base ti tabler-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
