@php
$configData = Helper::appClasses();
$initials = strtoupper(substr($restaurant->name ?? '', 0, 2));
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Wallet restaurante')

@section('page-style')
@vite('resources/assets/vendor/scss/pages/page-user-view.scss')
@endsection

@section('content')
<div class="row">
  <div class="col-xl-4 col-lg-5 order-1 order-md-0" id="detail-sidebar">
    <div class="card mb-6">
      <div class="card-body pt-12 position-relative">
        <div class="user-avatar-section">
          <div class="d-flex align-items-center flex-column">
            <div class="avatar avatar-xl mb-3">
              <span class="avatar-initial rounded bg-label-primary">{{ $initials }}</span>
            </div>
            <div class="user-info text-center">
              <h5>{{ $restaurant->name }}</h5>
              <span class="badge bg-label-{{ $restaurant->is_active ? 'success' : 'secondary' }}">
                {{ $restaurant->is_active ? 'Activo' : 'Inactivo' }}
              </span>
            </div>
          </div>
        </div>
        <div class="d-flex justify-content-around flex-wrap my-6 gap-0 gap-md-3 gap-lg-4">
          <div class="d-flex align-items-center gap-4">
            <div class="avatar">
              <div class="avatar-initial bg-label-primary rounded">
                <i class="icon-base ti tabler-wallet icon-lg"></i>
              </div>
            </div>
            <div>
              <h5 class="mb-0">€{{ number_format($restaurant->wallet_balance, 2) }}</h5>
              <span>Saldo</span>
            </div>
          </div>
          <div class="d-flex align-items-center gap-4">
            <div class="avatar">
              <div class="avatar-initial bg-label-info rounded">
                <i class="icon-base ti tabler-coin icon-lg"></i>
              </div>
            </div>
            <div>
              <h5 class="mb-0">€{{ number_format($restaurant->delivery_fee, 2) }}</h5>
              <span>Costo entrega</span>
            </div>
          </div>
        </div>
        <div class="d-flex justify-content-center">
          <a href="{{ route('admin.restaurants.show', $restaurant) }}" class="btn btn-label-secondary me-2">Volver</a>
          <a href="{{ route('admin.restaurants.edit', $restaurant) }}" class="btn btn-primary">Editar</a>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xl-8 col-lg-7 order-0 order-md-1" id="detail-main">
    <div class="nav-align-top mb-6">
      <ul class="nav nav-pills flex-column flex-md-row flex-wrap row-gap-2">
        <li class="nav-item">
          <a class="nav-link" href="{{ route('admin.restaurants.show', $restaurant) }}">
            <i class="icon-base ti tabler-clipboard-list icon-sm me-1_5"></i>Entregas
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{ route('admin.restaurants.movements', $restaurant) }}">
            <i class="icon-base ti tabler-wallet icon-sm me-1_5"></i>Movimientos
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="{{ route('admin.restaurants.wallet', $restaurant) }}">
            <i class="icon-base ti tabler-cash icon-sm me-1_5"></i>Wallet
          </a>
        </li>
      </ul>
    </div>

    @if (session('success'))
      <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if ($errors->any())
      <div class="alert alert-danger">
        <ul class="mb-0">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    <div class="card mb-6">
      <div class="card-header">
        <h5 class="mb-0">Saldo actual</h5>
      </div>
      <div class="card-body">
        <div class="display-6 mb-4">€{{ number_format($restaurant->wallet_balance, 2) }}</div>
        <div class="row g-3">
          <div class="col-md-6">
            <form method="POST" action="{{ route('admin.restaurants.wallet.topup', $restaurant) }}">
              @csrf
              <label class="form-label">Agregar saldo (€)</label>
              <div class="input-group">
                <input class="form-control" name="amount" type="number" step="0.01" min="0.01" required>
                <button class="btn btn-success" type="submit">Agregar</button>
              </div>
            </form>
          </div>
          <div class="col-md-6">
            <form method="POST" action="{{ route('admin.restaurants.wallet.charge', $restaurant) }}">
              @csrf
              <label class="form-label">Quitar saldo (€)</label>
              <div class="input-group">
                <input class="form-control" name="amount" type="number" step="0.01" min="0.01" required>
                <button class="btn btn-danger" type="submit">Quitar</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <div class="card mb-6">
      <div class="card-header">
        <h5 class="mb-0">Movimientos</h5>
      </div>
      <div class="table-responsive">
        <table class="table">
          <thead class="border-top">
            <tr>
              <th>Tipo</th>
              <th>Monto</th>
              <th>Saldo</th>
              <th>Descripción</th>
              <th>Fecha</th>
            </tr>
          </thead>
          <tbody>
            @forelse ($transactions as $tx)
              <tr>
                <td>{{ $tx->type }}</td>
                <td>€{{ number_format($tx->amount, 2) }}</td>
                <td>€{{ number_format($tx->balance_after, 2) }}</td>
                <td>{{ $tx->description ?? '-' }}</td>
                <td>{{ $tx->created_at->format('d/m/Y H:i') }}</td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center py-3">Sin movimientos.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      <div class="card-footer">
        {{ $transactions->links() }}
      </div>
    </div>
  </div>
</div>
@endsection
