@php
$configData = Helper::appClasses();
$stats = $stats ?? ['total' => 0, 'active' => 0, 'inactive' => 0, 'balance' => 0];
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Restaurantes')

@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
])
@endsection

@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
])
@endsection

@section('page-script')
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const table = document.querySelector('#restaurants-table');
    if (table && window.$ && $.fn.DataTable) {
      $('#restaurants-table').DataTable({
        order: [[2, 'asc']],
        pageLength: 10,
        language: {
          search: 'Buscar:',
          emptyTable: 'Sin restaurantes todavía.'
        }
      });
    }
  });
</script>
@endsection

@section('content')
<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
  <span></span>
</div>

@if (session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="row g-4 mb-4">
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Total</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['total'] }}</h4>
            </div>
            <small class="mb-0">Restaurantes registrados</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-primary">
              <i class="icon-base ti tabler-building-store icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Activos</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['active'] }}</h4>
            </div>
            <small class="mb-0">Operando ahora</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-success">
              <i class="icon-base ti tabler-circle-check icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Inactivos</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">{{ $stats['inactive'] }}</h4>
            </div>
            <small class="mb-0">Sin actividad</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-warning">
              <i class="icon-base ti tabler-alert-triangle icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-start justify-content-between">
          <div class="content-left">
            <span class="text-heading">Saldo total</span>
            <div class="d-flex align-items-center my-1">
              <h4 class="mb-0 me-2">€{{ number_format($stats['balance'], 2) }}</h4>
            </div>
            <small class="mb-0">Monederos</small>
          </div>
          <div class="avatar">
            <span class="avatar-initial rounded bg-label-info">
              <i class="icon-base ti tabler-wallet icon-26px"></i>
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header border-bottom d-flex align-items-center justify-content-between">
    <h5 class="card-title mb-0">Listado de restaurantes</h5>
    <a class="btn btn-primary btn-sm" href="{{ route('admin.restaurants.create') }}">
      <i class="icon-base ti tabler-plus me-1"></i> Nuevo restaurante
    </a>
  </div>
  <div class="card-datatable table-responsive">
    <table class="table" id="restaurants-table">
      <thead class="border-top">
        <tr>
          <th>Nombre</th>
          <th>Zona</th>
          <th>Teléfono</th>
          <th>Saldo</th>
          <th>Costo entrega</th>
          <th>Estado</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($restaurants as $restaurant)
          <tr>
            <td>
              <div class="d-flex align-items-center">
                <div class="avatar me-2">
                  <span class="avatar-initial rounded-circle bg-label-primary">
                    {{ strtoupper(substr($restaurant->name, 0, 2)) }}
                  </span>
                </div>
                <div class="d-flex flex-column">
                  <span class="fw-medium">{{ $restaurant->name }}</span>
                  <small class="text-muted">{{ $restaurant->contact_name ?? '—' }}</small>
                </div>
              </div>
            </td>
            <td>{{ $restaurant->zone?->name ?? '-' }}</td>
            <td>{{ $restaurant->phone ?? '-' }}</td>
            <td>€{{ number_format($restaurant->wallet_balance, 2) }}</td>
            <td>€{{ number_format($restaurant->delivery_fee, 2) }}</td>
            <td>
              <span class="badge bg-{{ $restaurant->is_active ? 'success' : 'secondary' }}">
                {{ $restaurant->is_active ? 'Activo' : 'Inactivo' }}
              </span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-icon btn-outline-secondary" href="{{ route('admin.restaurants.show', $restaurant) }}" title="Ver">
                <i class="icon-base ti tabler-eye"></i>
              </a>
              <a class="btn btn-sm btn-icon btn-outline-primary" href="{{ route('admin.restaurants.edit', $restaurant) }}" title="Editar">
                <i class="icon-base ti tabler-edit"></i>
              </a>
              <form class="d-inline" method="POST" action="{{ route('admin.restaurants.destroy', $restaurant) }}">
                @csrf
                @method('DELETE')
                <button class="btn btn-sm btn-icon btn-outline-danger" type="submit" onclick="return confirm('¿Eliminar restaurante?')" title="Eliminar">
                  <i class="icon-base ti tabler-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
