@php
$configData = Helper::appClasses();
$initials = strtoupper(substr($courier->name ?? '', 0, 2));
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Repartidor')

@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss',
  'resources/assets/vendor/libs/animate-css/animate.scss',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'
])
@endsection

@section('page-style')
@vite('resources/assets/vendor/scss/pages/page-user-view.scss')
@endsection

@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'
])
@endsection

@section('content')
<div class="row" id="detail-layout">
  <div class="col-xl-4 col-lg-5 order-1 order-md-0" id="detail-sidebar">
    <div class="card mb-6">
      <div class="card-body pt-12 position-relative">
        <div class="user-avatar-section">
          <div class="d-flex align-items-center flex-column">
            <div class="avatar avatar-xl mb-3">
              <span class="avatar-initial rounded bg-label-primary">{{ $initials }}</span>
            </div>
            <div class="user-info text-center">
              <h5>{{ $courier->name }}</h5>
              <span class="badge bg-label-{{ $courier->is_active ? 'success' : 'secondary' }}">
                {{ $courier->is_active ? 'Activo' : 'Inactivo' }}
              </span>
            </div>
          </div>
        </div>
        <div class="d-flex justify-content-around flex-wrap my-6 gap-0 gap-md-3 gap-lg-4">
          <div class="d-flex align-items-center gap-4">
            <div class="avatar">
              <div class="avatar-initial bg-label-primary rounded">
                <i class="icon-base ti tabler-wallet icon-lg"></i>
              </div>
            </div>
            <div>
              <h5 class="mb-0">€{{ number_format($courier->wallet_balance, 2) }}</h5>
              <span>Saldo</span>
            </div>
          </div>
          <div class="d-flex align-items-center gap-4">
            <div class="avatar">
              <div class="avatar-initial bg-label-info rounded">
                <i class="icon-base ti tabler-cash icon-lg"></i>
              </div>
            </div>
            <div>
              <h5 class="mb-0">€{{ number_format($courier->wallet_withdrawn, 2) }}</h5>
              <span>Retirado</span>
            </div>
          </div>
        </div>
        <h5 class="pb-4 border-bottom mb-4">Detalles</h5>
        <div class="info-container">
          <ul class="list-unstyled mb-6">
            <li class="mb-2"><span class="h6">Zona:</span> <span>{{ $courier->zone?->name ?? '-' }}</span></li>
            <li class="mb-2"><span class="h6">Teléfono:</span> <span>{{ $courier->phone ?? '-' }}</span></li>
            <li class="mb-2"><span class="h6">Email:</span> <span>{{ $courier->email ?? '-' }}</span></li>
            <li class="mb-2"><span class="h6">Vehículo:</span> <span>{{ $courier->vehicle_type ?? '-' }}</span></li>
          </ul>
          <div class="d-flex justify-content-center">
            <a href="{{ route('admin.couriers.edit', $courier) }}" class="btn btn-primary me-2">Editar</a>
            <a href="{{ route('admin.couriers.index') }}" class="btn btn-label-secondary">Volver</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xl-8 col-lg-7 order-0 order-md-1" id="detail-main">
    <div class="nav-align-top">
      <ul class="nav nav-pills flex-column flex-md-row flex-wrap mb-6 row-gap-2">
        <li class="nav-item">
          <a class="nav-link active" href="{{ route('admin.couriers.show', $courier) }}">
            <i class="icon-base ti tabler-clipboard-list icon-sm me-1_5"></i>Entregas
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{ route('admin.couriers.movements', $courier) }}">
            <i class="icon-base ti tabler-wallet icon-sm me-1_5"></i>Movimientos
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{ route('admin.couriers.wallet', $courier) }}">
            <i class="icon-base ti tabler-cash icon-sm me-1_5"></i>Wallet
          </a>
        </li>
      </ul>
      <button class="btn btn-icon btn-danger ms-auto sidebar-toggle-pill" type="button" data-toggle-sidebar title="Ocultar panel">
        <i class="icon-base ti tabler-layout-sidebar-right-collapse"></i>
      </button>
    </div>

    <div class="card mb-6">
      <div class="card-body">
        <div class="d-flex flex-wrap gap-4">
          <div><strong>{{ $counts['total'] }}</strong> total</div>
          <div><strong>{{ $counts['pending'] }}</strong> pendientes</div>
          <div><strong>{{ $counts['confirmed'] ?? 0 }}</strong> confirmados</div>
          <div><strong>{{ $counts['delivered'] ?? 0 }}</strong> entregados</div>
        </div>
      </div>
    </div>

    <div class="card mb-6">
      <div class="card-header">
        <h5 class="mb-0">Últimas entregas</h5>
      </div>
      <div class="table-responsive">
        <table class="table">
          <thead class="border-top">
            <tr>
              <th>#</th>
              <th>Cliente</th>
              <th>Dirección</th>
              <th>Estado</th>
              <th>Fecha</th>
            </tr>
          </thead>
          <tbody>
            @forelse ($deliveries as $delivery)
              <tr>
                <td>#{{ $delivery->id }}</td>
                <td>{{ $delivery->customer_name }}</td>
                <td>{{ $delivery->delivery_address }}</td>
                <td>{{ ucfirst($delivery->status) }}</td>
                <td>{{ $delivery->created_at->format('d/m/Y H:i') }}</td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center py-3">Sin entregas registradas.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>

    <div class="card mb-6">
      <div class="card-body">
        <h5 class="mb-3">Movimientos de monedero</h5>
        <div class="text-center text-muted">Sin movimientos.</div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('page-style')
@parent
<style>
  .sidebar-toggle-pill {
    border-radius: 12px;
    width: 44px;
    height: 44px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
  }
</style>
@endsection

@section('page-script')
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.getElementById('detail-sidebar');
    const main = document.getElementById('detail-main');
    const toggleBtn = document.querySelector('[data-toggle-sidebar]');
    if (!sidebar || !main || !toggleBtn) return;

    const storageKey = 'adminDetailSidebarCollapsed';
    const applyState = (collapsed) => {
      if (collapsed) {
        document.body.classList.add('sidebar-collapsed');
        sidebar.classList.add('d-none');
        main.classList.remove('col-xl-8', 'col-lg-7');
        main.classList.add('col-12');
        toggleBtn.title = 'Mostrar panel';
        toggleBtn.innerHTML = '<i class="icon-base ti tabler-layout-sidebar-right-expand"></i>';
      } else {
        document.body.classList.remove('sidebar-collapsed');
        sidebar.classList.remove('d-none');
        main.classList.remove('col-12');
        main.classList.add('col-xl-8', 'col-lg-7');
        toggleBtn.title = 'Ocultar panel';
        toggleBtn.innerHTML = '<i class="icon-base ti tabler-layout-sidebar-right-collapse"></i>';
      }
    };

    const saved = localStorage.getItem(storageKey) === '1';
    applyState(saved);

    toggleBtn.addEventListener('click', () => {
      const next = !sidebar.classList.contains('d-none');
      localStorage.setItem(storageKey, next ? '1' : '0');
      applyState(next);
    });
  });
</script>
@endsection
