@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Nuevo repartidor')

@section('content')
<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Nuevo repartidor</h4>
  <a class="btn btn-outline-secondary" href="{{ route('admin.couriers.index') }}">Volver</a>
</div>

@if ($errors->any())
  <div class="alert alert-danger">
    <ul class="mb-0">
      @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
@endif

<div class="card">
  <div class="card-body">
    <form method="POST" action="{{ route('admin.couriers.store') }}">
      @csrf
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Nombre</label>
          <input class="form-control" name="name" value="{{ old('name') }}" required />
        </div>
        <div class="col-md-6">
          <label class="form-label">Zona</label>
          <select class="form-select" name="zone_id">
            <option value="">Sin zona</option>
            @foreach ($zones as $zone)
              <option value="{{ $zone->id }}" @selected(old('zone_id') == $zone->id)>{{ $zone->name }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Teléfono</label>
          <input class="form-control" name="phone" value="{{ old('phone') }}" />
        </div>
        <div class="col-md-6">
          <label class="form-label">Email</label>
          <input class="form-control" name="email" value="{{ old('email') }}" />
        </div>
        <div class="col-md-6">
          <label class="form-label">Vehículo</label>
          <input class="form-control" name="vehicle_type" value="{{ old('vehicle_type') }}" />
        </div>
        <div class="col-12">
          <label class="form-label">Notas</label>
          <textarea class="form-control" name="notes" rows="3">{{ old('notes') }}</textarea>
        </div>
        <div class="col-md-6">
          <label class="form-label">Saldo inicial (€)</label>
          <input class="form-control" name="wallet_balance" type="number" step="0.01" min="0" value="{{ old('wallet_balance') }}" />
        </div>
        <div class="col-12">
          <hr class="my-2" />
          <h6 class="mb-2">Acceso del repartidor</h6>
        </div>
        <div class="col-md-6">
          <label class="form-label">Email de acceso</label>
          <input class="form-control" name="login_email" value="{{ old('login_email') }}"
            placeholder="login@repartidor.com" />
        </div>
        <div class="col-md-6">
          <label class="form-label">Contraseña</label>
          <input class="form-control" type="password" name="login_password" placeholder="Mínimo 6 caracteres" />
        </div>
        <div class="col-12">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" checked />
            <label class="form-check-label" for="is_active">Activo</label>
          </div>
        </div>
      </div>
      <div class="mt-3">
        <button class="btn btn-primary" type="submit">Guardar</button>
      </div>
    </form>
  </div>
</div>
@endsection
