<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'telegram_chat_id')) {
                // Telegram chat_id can exceed 32-bit; store as signed BIGINT.
                $table->bigInteger('telegram_chat_id')->nullable()->after('max_active_orders');
            }
            if (!Schema::hasColumn('users', 'telegram_connect_token')) {
                $table->string('telegram_connect_token', 80)->nullable()->unique()->after('telegram_chat_id');
            }
            if (!Schema::hasColumn('users', 'telegram_connected_at')) {
                $table->timestamp('telegram_connected_at')->nullable()->after('telegram_connect_token');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'telegram_connected_at')) {
                $table->dropColumn('telegram_connected_at');
            }
            if (Schema::hasColumn('users', 'telegram_connect_token')) {
                $table->dropUnique(['telegram_connect_token']);
                $table->dropColumn('telegram_connect_token');
            }
            if (Schema::hasColumn('users', 'telegram_chat_id')) {
                $table->dropColumn('telegram_chat_id');
            }
        });
    }
};

