<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            if (!Schema::hasColumn('deliveries', 'assigned_at')) {
                $table->timestamp('assigned_at')->nullable()->after('courier_id');
            }
            if (!Schema::hasColumn('deliveries', 'push_attempt')) {
                $table->unsignedTinyInteger('push_attempt')->default(0)->after('assigned_at');
            }
            if (!Schema::hasColumn('deliveries', 'push_last_sent_at')) {
                $table->timestamp('push_last_sent_at')->nullable()->after('push_attempt');
            }
        });
    }

    public function down(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            if (Schema::hasColumn('deliveries', 'push_last_sent_at')) {
                $table->dropColumn('push_last_sent_at');
            }
            if (Schema::hasColumn('deliveries', 'push_attempt')) {
                $table->dropColumn('push_attempt');
            }
            if (Schema::hasColumn('deliveries', 'assigned_at')) {
                $table->dropColumn('assigned_at');
            }
        });
    }
};

