<?php

namespace App\Http\Controllers\Courier;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class LocationController extends Controller
{
    public function store(Request $request)
    {
        $courier = $request->user()->courier;

        if (!$courier) {
            abort(403);
        }

        $data = $request->validate([
            'lat' => 'required|numeric',
            'lng' => 'required|numeric',
        ]);

        $courier->update([
            'last_lat' => $data['lat'],
            'last_lng' => $data['lng'],
            'last_seen_at' => now(),
        ]);

        return response()->json(['ok' => true]);
    }
}
